%{
This m-file belongs to the article 'The role of the electrolyte identity on
electrochemical CO2 conversion in the absence of mass transfer limitations'
Authors: Anne Sustronk (1,2) , Nieck E. Benes (1) , Guido Mul (2)
(1) Films in Fluids, Department of Science and Technology, University of 
Twente, Enschede, The Netherlands
(2) Photocatalytic Synthesis Group, Department of Science and Technology, 
University of Twente, Enschede, The Netherlands

The file is used to prepare Figures 3A and S2.

The next files are required to execute this file: ConstantCurrent.m, 
CalH2Data.txt, CalCOData.txt, CalFADataFeb22.txt, and CalErr.m

Note that the file location in line 32 of this file and in lines 46, 54, 59
of ConstantCurrent.m is to be added before execution

Brief overview of experimental conditions: Cu hollow fiber working 
electrode, 0.5M K2SO4 in MilliQ water, with or without the addition of 
H2SO4, Ar purged through fiber, chronopotentiometry at -25 mA

Version date m-file: Feb 24, 2023
%}

clear all, close all, clc

%% Size for plot (width, cm)

size = 6;

%% File location and name
Location = {'...\K2SO4\CP Ar flow'};

Folder1 = {'\-25 mA K2SO4 + 00 mM H2SO4 #1';
    '\-25 mA K2SO4 + 00 mM H2SO4 #2';
    '\-25 mA K2SO4 + 00 mM H2SO4 #3';
    '\-25 mA K2SO4 + 10 mM H2SO4 #1';
    '\-25 mA K2SO4 + 20 mM H2SO4 #1';
    '\-25 mA K2SO4 + 50 mM H2SO4 #1'};
   
% Data from potentiostat
FileNameEC = {'\-25 mA K2SO4 + 00 mM H2SO4 #1 CP.txt';
    '\-25 mA K2SO4 + 00 mM H2SO4 #2 CP.txt';
    '\-25 mA K2SO4 + 00 mM H2SO4 #3 CP.txt';
    '\-25 mA K2SO4 + 10 mM H2SO4 #1 CP.txt';
    '\-25 mA K2SO4 + 20 mM H2SO4 #1 CP.txt';
    '\-25 mA K2SO4 + 50 mM H2SO4 #1 CP.txt';};
    
% Geometric area
Area(1,1) = 0.908*mean([0.153 0.154])*pi();
Area(2,1) = 0.675*mean([0.146 0.149])*pi();
Area(3,1) = 0.662*mean([0.152 0.152])*pi();

Area(4,1) = Area(1,1);
Area(5,1) = Area(3,1);
Area(6,1) = Area(2,1);

% Error in geometric area
AreaErr(1,1) = 0.1*mean([0.153 0.154])*pi();
AreaErr(2,1) = 0.1*mean([0.146 0.149])*pi();
AreaErr(3,1) = 0.1*mean([0.152 0.152])*pi();

AreaErr(4,1) = AreaErr(1,1);
AreaErr(5,1) = AreaErr(3,1);
AreaErr(6,1) = AreaErr(2,1);

% Define variable name
VarName = ['Exp01'; 'Exp02'; 'Exp03'; 'Exp04'; 'Exp05'; 'Exp06'];

% File name for data file resitance data
RFileName = '\K2SO4 + H2SO4 Ar flow Resistances.txt';

% Call ConstantCurrent.m, with option to calculate FA partial current
% density (y/n)
Data = ConstantCurrent(Location, Folder1, FileNameEC, Area, AreaErr, VarName, RFileName, 'n');

%% Plot results

% Time
time = [mean([Data.Exp01.t Data.Exp02.t Data.Exp03.t],2), Data.Exp05.t, Data.Exp04.t, Data.Exp06.t];

% Potential at working electrode corrected for the internal resistance
Ereal = [mean([Data.Exp01.Ereal(:,1), Data.Exp02.Ereal(:,1), Data.Exp03.Ereal(:,1)],2), Data.Exp05.Ereal(:,1), Data.Exp04.Ereal(:,1), Data.Exp06.Ereal(:,1)];

%% Plot Ereal vs time
fig = figure(1);
hold on
plot(mean([Data.Exp01.t, Data.Exp02.t, Data.Exp03.t],2),mean([Data.Exp01.Ereal(:,1), Data.Exp02.Ereal(:,1), Data.Exp03.Ereal(:,1)],2), '-b')  % 0 mM H2SO4
plot(Data.Exp05.t,Data.Exp05.Ereal(:,1), '-r')  % 10 mM H2SO4
plot(Data.Exp04.t,Data.Exp04.Ereal(:,1), '-m')  % 20 mM H2SO4
plot(Data.Exp06.t,Data.Exp06.Ereal(:,1),'-k')   % 50 mM H2SO4
hold off

% Axis properties
box on
ax = gca;
ax.FontName = 'Times New Roman';
ax.TickDir = 'in';
ax.FontSize = 10;
ax.LineWidth = 1;
axis([0 4000 -2.0 -0.8]);
ax.XTick = linspace(0,4000,5);
ax.YTick = linspace(-2.0, -0.8, 7);
ytickformat(ax,'%.1f')

% X and Y label and legend
xlabel('Time (s)')
ylabel('E_{real} (V vs Ag/AgCl)')
legend('0 mM', '20 mM','10 mM', '50 mM','Location', 'South','NumColumns',2)

% Figure properties
fig.Units = 'centimeters';
fig.Color = 'white';
fig.Position = [2 5 size*(4/3) size];

%% Average IH2 vs H2SO4 concentration with errorbars
fig = figure(2);

hold on
errorbar(0,Data.IH2(1,1), Data.IH2(1,2) ,'*b')  % 0 mM H2SO4 #1
errorbar(0,Data.IH2(2,1),Data.IH2(2,2) ,'ob')   % 0 mM H2SO4 #2
errorbar(0,Data.IH2(3,1),Data.IH2(3,2) ,'^b')   % 0 mM H2SO4 #3
errorbar(10,Data.IH2(4,1),Data.IH2(4,2) ,'*m')  % 10 mM H2SO4
errorbar(20,Data.IH2(5,1),Data.IH2(5,2) ,'^r')  % 20 mM H2SO4
errorbar(50,Data.IH2(6,1),Data.IH2(6,2) ,'ok')  % 50 mM H2SO4
hold off

% Axis properties
box on
ax = gca;
ax.FontName = 'Times New Roman';
ax.TickDir = 'in';
ax.FontSize = 10;
ax.LineWidth = 1;
axis([0 60 -30 -20]);
ax.XTick = linspace(0,60,7);
ax.YTick = linspace(-30, -20, 3);

% X and Y label and legend
xlabel('H_{2}SO_{4} concentration (mM)')
ylabel('I_{H_{2}} (mA)')
legend('0 mM #1', '0 mM #2', '0 mM #3', '10 mM','20 mM', '50 mM','Location', 'SouthWest','NumColumns',2)

% Figure properties
fig.Units = 'centimeters';
fig.Color = 'white';
fig.Position = [25 5 size*(4/3) size];